BS	.=  $08		; backspace
SP	.=  $20		; space
CR	.=  $0D		; carriage return
LF	.=  $0A		; line feed
ESC	.=  $1B		; escape
INMASK  .=  $7F

OUTCH	.=  $FFEF	; Apple 1 Echo
PRHEX	.=  $FFE5	; Apple 1 Echo
OUTHEX	.=  $FFDC	; Apple 1 Print Hex Byte Routine
KBD     .=  $D010	; Apple 1 Keyboard character read.
KBDRDY  .=  $D011	; Apple 1 Keyboard data waiting when negative.

B1      .=  $5
B2      .=  $E5
W1      .=  $123
W2      .=  $CDCB

ALTEND  .= $1F

SRCL    .=  $10
SRCH    .=  $11

MAIN
	JSR TSTLDA
	JSR TSTSTA
	JSR TSTCMP
	JSR TSTEXP
	JSR TSTSBC
	JSR TSTORA
	JSR TSTAND
	JSR TSTEOR
	JSR TSTADC
	JSR TSTASL
	JSR TSTROL
	JSR TSTLSR
	JSR TSTROR
	JSR TSTDEC
	JSR TSTINC
	JSR TSTLDX
	JSR TSTSTX
	JSR TSTLDY
	JSR TSTCPS
	JSR TSTBSY
	JSR TSTJMP
	JSR TSTSNG
	JSR TSTBRA
	JSR TSTDIR
	JSR TSTFRF
	RTS
	
ERROR
	LDX #$00
.LOOP	LDA .MSG,X
	BEQ .DONE
	JSR OUTCH
	INX
	BNE .LOOP
.DONE	LDA SRCH
	JSR OUTHEX
	LDA SRCL
	JSR OUTHEX
	JSR CRLF
	RTS

.MSG	.S 'ERROR'
	.B SP
	.S 'IN'
	.B SP
	.S 'ROUTINE'
	.B SP
	.S 'AT'
	.B SP
	.S 'ADDRESS'
	.B SP
	.B $00

; LDA

TSTLDA

LDAIMM .= $A9
LDAZPG .= $A5
LDAZPX .= $B5
LDAABS .= $AD
LDAABX .= $BD
LDAABY .= $B9
LDAINX .= $A1
LDAINY .= $B1

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	LDA #$5		; CONSTANTS
	LDA #$E5	
	LDA #B1
	LDA #B2
	LDA #'A'
	LDA #'A'
	
	LDA $5		; ZERO PAGE LOCATIONS
	LDA $E5
	LDA B1
	LDA B2

	LDA $5,X	; ZERO PAGE INDEXED,X
	LDA $E5,X
	LDA B1,X
	LDA B2,X
	
	LDA $123	; ABSOLUTE LOCATIONS
	LDA $CDCB
	LDA W1
	LDA W2
	
	LDA $123,X	; ABSOLUTE INDEXED,X
	LDA $CDCB,X
	LDA W1,X
	LDA W2,X
	
	LDA $123,Y	; ABSOLUTE INDEXED,Y
	LDA $CDCB,Y
	LDA W1,Y
	LDA W2,Y
	
	LDA ($5,X)	; INDEXED INDIRECT,X
	LDA ($E5,X)
	LDA (B1,X)
	LDA (B2,X)
	
	LDA ($5),Y	; INDIRECT INDEXED,Y
	LDA ($E5),Y
	LDA (B1),Y
	LDA (B2),Y
	
	.B $00	; indicates end of source
	
.DATA	.B LDAIMM
	.B $5
	.B LDAIMM
	.B $E5
	.B LDAIMM
	.B B1
	.B LDAIMM
	.B B2	
	.B LDAIMM
	.B 'A'
	.B LDAIMM
	.B $41	
	
	.B LDAZPG
	.B $5
	.B LDAZPG
	.B $E5
	.B LDAZPG
	.B B1
	.B LDAZPG
	.B B2
	
	.B LDAZPX
	.B $5
	.B LDAZPX
	.B $E5
	.B LDAZPX
	.B B1
	.B LDAZPX
	.B B2	
	
	.B LDAABS
	.W $123
	.B LDAABS
	.W $CDCB
	.B LDAABS
	.W W1
	.B LDAABS
	.W W2
	
	.B LDAABX
	.W $123
	.B LDAABX
	.W $CDCB
	.B LDAABX
	.W W1
	.B LDAABX
	.W W2
	
	.B LDAABY
	.W $123
	.B LDAABY
	.W $CDCB
	.B LDAABY
	.W W1
	.B LDAABY
	.W W2
	
	.B LDAINX
	.B $5
	.B LDAINX
	.B $E5
	.B LDAINX
	.B B1
	.B LDAINX
	.B B2
	
	.B LDAINY
	.B $5
	.B LDAINY
	.B $E5
	.B LDAINY
	.B B1
	.B LDAINY
	.B B2

; STA

TSTSTA

STAZPG .= $85
STAZPX .= $95
STAABS .= $8D
STAABX .= $9D
STAABY .= $99
STAINX .= $81
STAINY .= $91

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	STA $5		; ZERO PAGE LOCATIONS
	STA $E5
	STA B1
	STA B2

	STA $5,X	; ZERO PAGE INDEXED,X
	STA $E5,X
	STA B1,X
	STA B2,X
	
	STA $123	; ABSOLUTE LOCATIONS
	STA $CDCB
	STA W1
	STA W2
	
	STA $123,X	; ABSOLUTE INDEXED,X
	STA $CDCB,X
	STA W1,X
	STA W2,X
	
	STA $123,Y	; ABSOLUTE INDEXED,Y
	STA $CDCB,Y
	STA W1,Y
	STA W2,Y
	
	STA ($5,X)	; INDEXED INDIRECT,X
	STA ($E5,X)
	STA (B1,X)
	STA (B2,X)
	
	STA ($5),Y	; INDIRECT INDEXED,Y
	STA ($E5),Y
	STA (B1),Y
	STA (B2),Y
	
	.B $00	; indicates end of source
	
.DATA	.B STAZPG
	.B $5
	.B STAZPG
	.B $E5
	.B STAZPG
	.B B1
	.B STAZPG
	.B B2
	
	.B STAZPX
	.B $5
	.B STAZPX
	.B $E5
	.B STAZPX
	.B B1
	.B STAZPX
	.B B2	
	
	.B STAABS
	.W $123
	.B STAABS
	.W $CDCB
	.B STAABS
	.W W1
	.B STAABS
	.W W2
	
	.B STAABX
	.W $123
	.B STAABX
	.W $CDCB
	.B STAABX
	.W W1
	.B STAABX
	.W W2
	
	.B STAABY
	.W $123
	.B STAABY
	.W $CDCB
	.B STAABY
	.W W1
	.B STAABY
	.W W2
	
	.B STAINX
	.B $5
	.B STAINX
	.B $E5
	.B STAINX
	.B B1
	.B STAINX
	.B B2
	
	.B STAINY
	.B $5
	.B STAINY
	.B $E5
	.B STAINY
	.B B1
	.B STAINY
	.B B2

; CMP

TSTCMP

CMPIMM .= $C9
CMPZPG .= $C5
CMPZPX .= $D5
CMPABS .= $CD
CMPABX .= $DD
CMPABY .= $D9
CMPINX .= $C1
CMPINY .= $D1

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	CMP #$5		; CONSTANTS
	CMP #$E5	
	CMP #B1
	CMP #B2
	
	CMP $5		; ZERO PAGE LOCATIONS
	CMP $E5
	CMP B1
	CMP B2

	CMP $5,X	; ZERO PAGE INDEXED,X
	CMP $E5,X
	CMP B1,X
	CMP B2,X
	
	CMP $123	; ABSOLUTE LOCATIONS
	CMP $CDCB
	CMP W1
	CMP W2
	
	CMP $123,X	; ABSOLUTE INDEXED,X
	CMP $CDCB,X
	CMP W1,X
	CMP W2,X
	
	CMP $123,Y	; ABSOLUTE INDEXED,Y
	CMP $CDCB,Y
	CMP W1,Y
	CMP W2,Y
	
	CMP ($5,X)	; INDEXED INDIRECT,X
	CMP ($E5,X)
	CMP (B1,X)
	CMP (B2,X)
	
	CMP ($5),Y	; INDIRECT INDEXED,Y
	CMP ($E5),Y
	CMP (B1),Y
	CMP (B2),Y
	
	.B $00	; indicates end of source
	
.DATA	.B CMPIMM
	.B $5
	.B CMPIMM
	.B $E5
	.B CMPIMM
	.B B1
	.B CMPIMM
	.B B2	
	
	.B CMPZPG
	.B $5
	.B CMPZPG
	.B $E5
	.B CMPZPG
	.B B1
	.B CMPZPG
	.B B2
	
	.B CMPZPX
	.B $5
	.B CMPZPX
	.B $E5
	.B CMPZPX
	.B B1
	.B CMPZPX
	.B B2	
	
	.B CMPABS
	.W $123
	.B CMPABS
	.W $CDCB
	.B CMPABS
	.W W1
	.B CMPABS
	.W W2
	
	.B CMPABX
	.W $123
	.B CMPABX
	.W $CDCB
	.B CMPABX
	.W W1
	.B CMPABX
	.W W2
	
	.B CMPABY
	.W $123
	.B CMPABY
	.W $CDCB
	.B CMPABY
	.W W1
	.B CMPABY
	.W W2
	
	.B CMPINX
	.B $5
	.B CMPINX
	.B $E5
	.B CMPINX
	.B B1
	.B CMPINX
	.B B2
	
	.B CMPINY
	.B $5
	.B CMPINY
	.B $E5
	.B CMPINY
	.B B1
	.B CMPINY
	.B B2

; SBC

TSTSBC

SBCIMM .= $E9
SBCZPG .= $E5
SBCZPX .= $F5
SBCABS .= $ED
SBCABX .= $FD
SBCABY .= $F9
SBCINX .= $E1
SBCINY .= $F1

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	SBC #$5		; CONSTANTS
	SBC #$E5	
	SBC #B1
	SBC #B2
	
	SBC $5		; ZERO PAGE LOCATIONS
	SBC $E5
	SBC B1
	SBC B2

	SBC $5,X	; ZERO PAGE INDEXED,X
	SBC $E5,X
	SBC B1,X
	SBC B2,X
	
	SBC $123	; ABSOLUTE LOCATIONS
	SBC $CDCB
	SBC W1
	SBC W2
	
	SBC $123,X	; ABSOLUTE INDEXED,X
	SBC $CDCB,X
	SBC W1,X
	SBC W2,X
	
	SBC $123,Y	; ABSOLUTE INDEXED,Y
	SBC $CDCB,Y
	SBC W1,Y
	SBC W2,Y
	
	SBC ($5,X)	; INDEXED INDIRECT,X
	SBC ($E5,X)
	SBC (B1,X)
	SBC (B2,X)
	
	SBC ($5),Y	; INDIRECT INDEXED,Y
	SBC ($E5),Y
	SBC (B1),Y
	SBC (B2),Y
	
	.B $00	; indicates end of source
	
.DATA	.B SBCIMM
	.B $5
	.B SBCIMM
	.B $E5
	.B SBCIMM
	.B B1
	.B SBCIMM
	.B B2	
	
	.B SBCZPG
	.B $5
	.B SBCZPG
	.B $E5
	.B SBCZPG
	.B B1
	.B SBCZPG
	.B B2
	
	.B SBCZPX
	.B $5
	.B SBCZPX
	.B $E5
	.B SBCZPX
	.B B1
	.B SBCZPX
	.B B2	
	
	.B SBCABS
	.W $123
	.B SBCABS
	.W $CDCB
	.B SBCABS
	.W W1
	.B SBCABS
	.W W2
	
	.B SBCABX
	.W $123
	.B SBCABX
	.W $CDCB
	.B SBCABX
	.W W1
	.B SBCABX
	.W W2
	
	.B SBCABY
	.W $123
	.B SBCABY
	.W $CDCB
	.B SBCABY
	.W W1
	.B SBCABY
	.W W2
	
	.B SBCINX
	.B $5
	.B SBCINX
	.B $E5
	.B SBCINX
	.B B1
	.B SBCINX
	.B B2
	
	.B SBCINY
	.B $5
	.B SBCINY
	.B $E5
	.B SBCINY
	.B B1
	.B SBCINY
	.B B2

; ORA

TSTORA

ORAIMM .= $09
ORAZPG .= $05
ORAZPX .= $15
ORAABS .= $0D
ORAABX .= $1D
ORAABY .= $19
ORAINX .= $01
ORAINY .= $11

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	ORA #$5		; CONSTANTS
	ORA #$E5	
	ORA #B1
	ORA #B2
	
	ORA $5		; ZERO PAGE LOCATIONS
	ORA $E5
	ORA B1
	ORA B2

	ORA $5,X	; ZERO PAGE INDEXED,X
	ORA $E5,X
	ORA B1,X
	ORA B2,X
	
	ORA $123	; ABSOLUTE LOCATIONS
	ORA $CDCB
	ORA W1
	ORA W2
	
	ORA $123,X	; ABSOLUTE INDEXED,X
	ORA $CDCB,X
	ORA W1,X
	ORA W2,X
	
	ORA $123,Y	; ABSOLUTE INDEXED,Y
	ORA $CDCB,Y
	ORA W1,Y
	ORA W2,Y
	
	ORA ($5,X)	; INDEXED INDIRECT,X
	ORA ($E5,X)
	ORA (B1,X)
	ORA (B2,X)
	
	ORA ($5),Y	; INDIRECT INDEXED,Y
	ORA ($E5),Y
	ORA (B1),Y
	ORA (B2),Y
	
	.B $00	; indicates end of source
	
.DATA	.B ORAIMM
	.B $5
	.B ORAIMM
	.B $E5
	.B ORAIMM
	.B B1
	.B ORAIMM
	.B B2	
	
	.B ORAZPG
	.B $5
	.B ORAZPG
	.B $E5
	.B ORAZPG
	.B B1
	.B ORAZPG
	.B B2
	
	.B ORAZPX
	.B $5
	.B ORAZPX
	.B $E5
	.B ORAZPX
	.B B1
	.B ORAZPX
	.B B2	
	
	.B ORAABS
	.W $123
	.B ORAABS
	.W $CDCB
	.B ORAABS
	.W W1
	.B ORAABS
	.W W2
	
	.B ORAABX
	.W $123
	.B ORAABX
	.W $CDCB
	.B ORAABX
	.W W1
	.B ORAABX
	.W W2
	
	.B ORAABY
	.W $123
	.B ORAABY
	.W $CDCB
	.B ORAABY
	.W W1
	.B ORAABY
	.W W2
	
	.B ORAINX
	.B $5
	.B ORAINX
	.B $E5
	.B ORAINX
	.B B1
	.B ORAINX
	.B B2
	
	.B ORAINY
	.B $5
	.B ORAINY
	.B $E5
	.B ORAINY
	.B B1
	.B ORAINY
	.B B2

; AND

TSTAND

ANDIMM .= $29
ANDZPG .= $25
ANDZPX .= $35
ANDABS .= $2D
ANDABX .= $3D
ANDABY .= $39
ANDINX .= $21
ANDINY .= $31

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	AND #$5		; CONSTANTS
	AND #$E5	
	AND #B1
	AND #B2

	AND $5		; ZERO PAGE LOCATIONS
	AND $E5
	AND B1
	AND B2

	AND $5,X	; ZERO PAGE INDEXED,X
	AND $E5,X
	AND B1,X
	AND B2,X
	
	AND $123	; ABSOLUTE LOCATIONS
	AND $CDCB
	AND W1
	AND W2
	
	AND $123,X	; ABSOLUTE INDEXED,X
	AND $CDCB,X
	AND W1,X
	AND W2,X
	
	AND $123,Y	; ABSOLUTE INDEXED,Y
	AND $CDCB,Y
	AND W1,Y
	AND W2,Y
	
	AND ($5,X)	; INDEXED INDIRECT,X
	AND ($E5,X)
	AND (B1,X)
	AND (B2,X)
	
	AND ($5),Y	; INDIRECT INDEXED,Y
	AND ($E5),Y
	AND (B1),Y
	AND (B2),Y
	
	.B $00	; indicates end of source
	
.DATA	.B ANDIMM
	.B $5
	.B ANDIMM
	.B $E5
	.B ANDIMM
	.B B1
	.B ANDIMM
	.B B2	
	
	.B ANDZPG
	.B $5
	.B ANDZPG
	.B $E5
	.B ANDZPG
	.B B1
	.B ANDZPG
	.B B2
	
	.B ANDZPX
	.B $5
	.B ANDZPX
	.B $E5
	.B ANDZPX
	.B B1
	.B ANDZPX
	.B B2	
	
	.B ANDABS
	.W $123
	.B ANDABS
	.W $CDCB
	.B ANDABS
	.W W1
	.B ANDABS
	.W W2
	
	.B ANDABX
	.W $123
	.B ANDABX
	.W $CDCB
	.B ANDABX
	.W W1
	.B ANDABX
	.W W2
	
	.B ANDABY
	.W $123
	.B ANDABY
	.W $CDCB
	.B ANDABY
	.W W1
	.B ANDABY
	.W W2
	
	.B ANDINX
	.B $5
	.B ANDINX
	.B $E5
	.B ANDINX
	.B B1
	.B ANDINX
	.B B2
	
	.B ANDINY
	.B $5
	.B ANDINY
	.B $E5
	.B ANDINY
	.B B1
	.B ANDINY
	.B B2

; EOR

TSTEOR

EORIMM .= $49
EORZPG .= $45
EORZPX .= $55
EORABS .= $4D
EORABX .= $5D
EORABY .= $59
EORINX .= $41
EORINY .= $51

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	EOR #$5		; CONSTANTS
	EOR #$E5	
	EOR #B1
	EOR #B2
	
	EOR $5		; ZERO PAGE LOCATIONS
	EOR $E5
	EOR B1
	EOR B2

	EOR $5,X	; ZERO PAGE INDEXED,X
	EOR $E5,X
	EOR B1,X
	EOR B2,X
	
	EOR $123	; ABSOLUTE LOCATIONS
	EOR $CDCB
	EOR W1
	EOR W2
	
	EOR $123,X	; ABSOLUTE INDEXED,X
	EOR $CDCB,X
	EOR W1,X
	EOR W2,X
	
	EOR $123,Y	; ABSOLUTE INDEXED,Y
	EOR $CDCB,Y
	EOR W1,Y
	EOR W2,Y
	
	EOR ($5,X)	; INDEXED INDIRECT,X
	EOR ($E5,X)
	EOR (B1,X)
	EOR (B2,X)
	
	EOR ($5),Y	; INDIRECT INDEXED,Y
	EOR ($E5),Y
	EOR (B1),Y
	EOR (B2),Y
	
	.B $00	; indicates end of source
	
.DATA	.B EORIMM
	.B $5
	.B EORIMM
	.B $E5
	.B EORIMM
	.B B1
	.B EORIMM
	.B B2	
	
	.B EORZPG
	.B $5
	.B EORZPG
	.B $E5
	.B EORZPG
	.B B1
	.B EORZPG
	.B B2
	
	.B EORZPX
	.B $5
	.B EORZPX
	.B $E5
	.B EORZPX
	.B B1
	.B EORZPX
	.B B2	
	
	.B EORABS
	.W $123
	.B EORABS
	.W $CDCB
	.B EORABS
	.W W1
	.B EORABS
	.W W2
	
	.B EORABX
	.W $123
	.B EORABX
	.W $CDCB
	.B EORABX
	.W W1
	.B EORABX
	.W W2
	
	.B EORABY
	.W $123
	.B EORABY
	.W $CDCB
	.B EORABY
	.W W1
	.B EORABY
	.W W2
	
	.B EORINX
	.B $5
	.B EORINX
	.B $E5
	.B EORINX
	.B B1
	.B EORINX
	.B B2
	
	.B EORINY
	.B $5
	.B EORINY
	.B $E5
	.B EORINY
	.B B1
	.B EORINY
	.B B2

; ADC

TSTADC

ADCIMM .= $69
ADCZPG .= $65
ADCZPX .= $75
ADCABS .= $6D
ADCABX .= $7D
ADCABY .= $79
ADCINX .= $61
ADCINY .= $71

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	ADC #$5		; CONSTANTS
	ADC #$E5	
	ADC #B1
	ADC #B2
	
	ADC $5		; ZERO PAGE LOCATIONS
	ADC $E5
	ADC B1
	ADC B2

	ADC $5,X	; ZERO PAGE INDEXED,X
	ADC $E5,X
	ADC B1,X
	ADC B2,X
	
	ADC $123	; ABSOLUTE LOCATIONS
	ADC $CDCB
	ADC W1
	ADC W2
	
	ADC $123,X	; ABSOLUTE INDEXED,X
	ADC $CDCB,X
	ADC W1,X
	ADC W2,X
	
	ADC $123,Y	; ABSOLUTE INDEXED,Y
	ADC $CDCB,Y
	ADC W1,Y
	ADC W2,Y
	
	ADC ($5,X)	; INDEXED INDIRECT,X
	ADC ($E5,X)
	ADC (B1,X)
	ADC (B2,X)
	
	ADC ($5),Y	; INDIRECT INDEXED,Y
	ADC ($E5),Y
	ADC (B1),Y
	ADC (B2),Y
	
	.B $00	; indicates end of source
	
.DATA	.B ADCIMM
	.B $5
	.B ADCIMM
	.B $E5
	.B ADCIMM
	.B B1
	.B ADCIMM
	.B B2	
	
	.B ADCZPG
	.B $5
	.B ADCZPG
	.B $E5
	.B ADCZPG
	.B B1
	.B ADCZPG
	.B B2
	
	.B ADCZPX
	.B $5
	.B ADCZPX
	.B $E5
	.B ADCZPX
	.B B1
	.B ADCZPX
	.B B2	
	
	.B ADCABS
	.W $123
	.B ADCABS
	.W $CDCB
	.B ADCABS
	.W W1
	.B ADCABS
	.W W2
	
	.B ADCABX
	.W $123
	.B ADCABX
	.W $CDCB
	.B ADCABX
	.W W1
	.B ADCABX
	.W W2
	
	.B ADCABY
	.W $123
	.B ADCABY
	.W $CDCB
	.B ADCABY
	.W W1
	.B ADCABY
	.W W2
	
	.B ADCINX
	.B $5
	.B ADCINX
	.B $E5
	.B ADCINX
	.B B1
	.B ADCINX
	.B B2
	
	.B ADCINY
	.B $5
	.B ADCINY
	.B $E5
	.B ADCINY
	.B B1
	.B ADCINY
	.B B2

; ASL

TSTASL

ASLACC .= $0A
ASLZPG .= $06
ASLABS .= $0E
ASLZPX .= $16
ASLABX .= $1E

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	ASL

	ASL $5		; ZERO PAGE LOCATIONS
	ASL $E5
	ASL B1
	ASL B2

	ASL $5,X	; ZERO PAGE INDEXED,X
	ASL $E5,X
	ASL B1,X
	ASL B2,X
	
	ASL $123	; ABSOLUTE LOCATIONS
	ASL $CDCB
	ASL W1
	ASL W2
	
	ASL $123,X	; ABSOLUTE INDEXED,X
	ASL $CDCB,X
	ASL W1,X
	ASL W2,X
	
	.B $00	; indicates end of source
	
.DATA	.B ASLACC

	.B ASLZPG
	.B $5
	.B ASLZPG
	.B $E5
	.B ASLZPG
	.B B1
	.B ASLZPG
	.B B2
	
	.B ASLZPX
	.B $5
	.B ASLZPX
	.B $E5
	.B ASLZPX
	.B B1
	.B ASLZPX
	.B B2	
	
	.B ASLABS
	.W $123
	.B ASLABS
	.W $CDCB
	.B ASLABS
	.W W1
	.B ASLABS
	.W W2
	
	.B ASLABX
	.W $123
	.B ASLABX
	.W $CDCB
	.B ASLABX
	.W W1
	.B ASLABX
	.W W2
	
; ROL

TSTROL

ROLACC .= $2A
ROLZPG .= $26
ROLABS .= $2E
ROLZPX .= $36
ROLABX .= $3E

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	ROL

	ROL $5		; ZERO PAGE LOCATIONS
	ROL $E5
	ROL B1
	ROL B2

	ROL $5,X	; ZERO PAGE INDEXED,X
	ROL $E5,X
	ROL B1,X
	ROL B2,X
	
	ROL $123	; ABSOLUTE LOCATIONS
	ROL $CDCB
	ROL W1
	ROL W2
	
	ROL $123,X	; ABSOLUTE INDEXED,X
	ROL $CDCB,X
	ROL W1,X
	ROL W2,X

	.B $00	; indicates end of source
	
.DATA	.B ROLACC

	.B ROLZPG
	.B $5
	.B ROLZPG
	.B $E5
	.B ROLZPG
	.B B1
	.B ROLZPG
	.B B2
	
	.B ROLZPX
	.B $5
	.B ROLZPX
	.B $E5
	.B ROLZPX
	.B B1
	.B ROLZPX
	.B B2	
	
	.B ROLABS
	.W $123
	.B ROLABS
	.W $CDCB
	.B ROLABS
	.W W1
	.B ROLABS
	.W W2
	
	.B ROLABX
	.W $123
	.B ROLABX
	.W $CDCB
	.B ROLABX
	.W W1
	.B ROLABX
	.W W2

; LSR

TSTLSR

LSRACC .= $4A
LSRZPG .= $46
LSRABS .= $4E
LSRZPX .= $56
LSRABX .= $5E

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	LSR

	LSR $5		; ZERO PAGE LOCATIONS
	LSR $E5
	LSR B1
	LSR B2

	LSR $5,X	; ZERO PAGE INDEXED,X
	LSR $E5,X
	LSR B1,X
	LSR B2,X
	
	LSR $123	; ABSOLUTE LOCATIONS
	LSR $CDCB
	LSR W1
	LSR W2
	
	LSR $123,X	; ABSOLUTE INDEXED,X
	LSR $CDCB,X
	LSR W1,X
	LSR W2,X

	.B $00	; indicates end of source
	
.DATA	.B LSRACC

	.B LSRZPG
	.B $5
	.B LSRZPG
	.B $E5
	.B LSRZPG
	.B B1
	.B LSRZPG
	.B B2
	
	.B LSRZPX
	.B $5
	.B LSRZPX
	.B $E5
	.B LSRZPX
	.B B1
	.B LSRZPX
	.B B2	
	
	.B LSRABS
	.W $123
	.B LSRABS
	.W $CDCB
	.B LSRABS
	.W W1
	.B LSRABS
	.W W2
	
	.B LSRABX
	.W $123
	.B LSRABX
	.W $CDCB
	.B LSRABX
	.W W1
	.B LSRABX
	.W W2

; ROR

TSTROR

RORACC .= $6A
RORZPG .= $66
RORABS .= $6E
RORZPX .= $76
RORABX .= $7E

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	ROR

	ROR $5		; ZERO PAGE LOCATIONS
	ROR $E5
	ROR B1
	ROR B2

	ROR $5,X	; ZERO PAGE INDEXED,X
	ROR $E5,X
	ROR B1,X
	ROR B2,X
	
	ROR $123	; ABSOLUTE LOCATIONS
	ROR $CDCB
	ROR W1
	ROR W2
	
	ROR $123,X	; ABSOLUTE INDEXED,X
	ROR $CDCB,X
	ROR W1,X
	ROR W2,X

	.B $00	; indicates end of source
	
.DATA	.B RORACC

	.B RORZPG
	.B $5
	.B RORZPG
	.B $E5
	.B RORZPG
	.B B1
	.B RORZPG
	.B B2
	
	.B RORZPX
	.B $5
	.B RORZPX
	.B $E5
	.B RORZPX
	.B B1
	.B RORZPX
	.B B2	
	
	.B RORABS
	.W $123
	.B RORABS
	.W $CDCB
	.B RORABS
	.W W1
	.B RORABS
	.W W2
	
	.B RORABX
	.W $123
	.B RORABX
	.W $CDCB
	.B RORABX
	.W W1
	.B RORABX
	.W W2

; DEC

TSTDEC

DECZPG .= $C6
DECABS .= $CE
DECZPX .= $D6
DECABX .= $DE

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	DEC $5		; ZERO PAGE LOCATIONS
	DEC $E5
	DEC B1
	DEC B2

	DEC $5,X	; ZERO PAGE INDEXED,X
	DEC $E5,X
	DEC B1,X
	DEC B2,X
	
	DEC $123	; ABSOLUTE LOCATIONS
	DEC $CDCB
	DEC W1
	DEC W2
	
	DEC $123,X	; ABSOLUTE INDEXED,X
	DEC $CDCB,X
	DEC W1,X
	DEC W2,X

	.B $00	; indicates end of source
	
.DATA	.B DECZPG
	.B $5
	.B DECZPG
	.B $E5
	.B DECZPG
	.B B1
	.B DECZPG
	.B B2
	
	.B DECZPX
	.B $5
	.B DECZPX
	.B $E5
	.B DECZPX
	.B B1
	.B DECZPX
	.B B2	
	
	.B DECABS
	.W $123
	.B DECABS
	.W $CDCB
	.B DECABS
	.W W1
	.B DECABS
	.W W2
	
	.B DECABX
	.W $123
	.B DECABX
	.W $CDCB
	.B DECABX
	.W W1
	.B DECABX
	.W W2

; INC

TSTINC

INCZPG .= $E6
INCABS .= $EE
INCZPX .= $F6
INCABX .= $FE

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	INC $5		; ZERO PAGE LOCATIONS
	INC $E5
	INC B1
	INC B2

	INC $5,X	; ZERO PAGE INDEXED,X
	INC $E5,X
	INC B1,X
	INC B2,X
	
	INC $123	; ABSOLUTE LOCATIONS
	INC $CDCB
	INC W1
	INC W2
	
	INC $123,X	; ABSOLUTE INDEXED,X
	INC $CDCB,X
	INC W1,X
	INC W2,X

	.B $00	; indicates end of source
	
.DATA	.B INCZPG
	.B $5
	.B INCZPG
	.B $E5
	.B INCZPG
	.B B1
	.B INCZPG
	.B B2
	
	.B INCZPX
	.B $5
	.B INCZPX
	.B $E5
	.B INCZPX
	.B B1
	.B INCZPX
	.B B2	
	
	.B INCABS
	.W $123
	.B INCABS
	.W $CDCB
	.B INCABS
	.W W1
	.B INCABS
	.W W2
	
	.B INCABX
	.W $123
	.B INCABX
	.W $CDCB
	.B INCABX
	.W W1
	.B INCABX
	.W W2

; LDX

TSTLDX

LDXIMM .= $A2
LDXZPG .= $A6
LDXABS .= $AE
LDXZPY .= $B6
LDXABY .= $BE

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	LDX #$5		; IMMEDIATE
	LDX #$E5
	LDX #B1
	LDX #B2
	
	LDX $5		; ZERO PAGE LOCATIONS
	LDX $E5
	LDX B1
	LDX B2

	LDX $5,Y	; ZERO PAGE INDEXED,Y
	LDX $E5,Y
	LDX B1,Y
	LDX B2,Y
	
	LDX $123	; ABSOLUTE LOCATIONS
	LDX $CDCB
	LDX W1
	LDX W2
	
	LDX $123,Y	; ABSOLUTE INDEXED,Y
	LDX $CDCB,Y
	LDX W1,Y
	LDX W2,Y

	.B $00	; indicates end of source
	
.DATA	.B LDXIMM
	.B $5
	.B LDXIMM
	.B $E5
	.B LDXIMM
	.B B1
	.B LDXIMM
	.B B2
	
	.B LDXZPG
	.B $5
	.B LDXZPG
	.B $E5
	.B LDXZPG
	.B B1
	.B LDXZPG
	.B B2
	
	.B LDXZPY
	.B $5
	.B LDXZPY
	.B $E5
	.B LDXZPY
	.B B1
	.B LDXZPY
	.B B2	
	
	.B LDXABS
	.W $123
	.B LDXABS
	.W $CDCB
	.B LDXABS
	.W W1
	.B LDXABS
	.W W2
	
	.B LDXABY
	.W $123
	.B LDXABY
	.W $CDCB
	.B LDXABY
	.W W1
	.B LDXABY
	.W W2
; STX

TSTSTX

STXZPG .= $86
STXABS .= $8E
STXZPY .= $96

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	STX $5		; ZERO PAGE LOCATIONS
	STX $E5
	STX B1
	STX B2

	STX $5,Y	; ZERO PAGE INDEXED,Y
	STX $E5,Y
	STX B1,Y
	STX B2,Y
	
	STX $123	; ABSOLUTE LOCATIONS
	STX $CDCB
	STX W1
	STX W2
	
	.B $00	; indicates end of source
	
.DATA	.B STXZPG
	.B $5
	.B STXZPG
	.B $E5
	.B STXZPG
	.B B1
	.B STXZPG
	.B B2
	
	.B STXZPY
	.B $5
	.B STXZPY
	.B $E5
	.B STXZPY
	.B B1
	.B STXZPY
	.B B2	
	
	.B STXABS
	.W $123
	.B STXABS
	.W $CDCB
	.B STXABS
	.W W1
	.B STXABS
	.W W2

; LDY

TSTLDY

LDYIMM .= $A0
LDYZPG .= $A4
LDYABS .= $AC
LDYZPX .= $B4
LDYABX .= $BC

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDY #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	LDY #$5		; IMMEDIATE
	LDY #$E5
	LDY #B1
	LDY #B2
	
	LDY $5		; ZERO PAGE LOCATIONS
	LDY $E5
	LDY B1
	LDY B2

	LDY $5,X	; ZERO PAGE INDEXED,X
	LDY $E5,X
	LDY B1,X
	LDY B2,X
	
	LDY $123	; ABSOLUTE LOCATIONS
	LDY $CDCB
	LDY W1
	LDY W2
	
	LDY $123,X	; ABSOLUTE INDEXED,X
	LDY $CDCB,X
	LDY W1,X
	LDY W2,X

	.B $00	; indicates end of source
	
.DATA	.B LDYIMM
	.B $5
	.B LDYIMM
	.B $E5
	.B LDYIMM
	.B B1
	.B LDYIMM
	.B B2
	
	.B LDYZPG
	.B $5
	.B LDYZPG
	.B $E5
	.B LDYZPG
	.B B1
	.B LDYZPG
	.B B2
	
	.B LDYZPX
	.B $5
	.B LDYZPX
	.B $E5
	.B LDYZPX
	.B B1
	.B LDYZPX
	.B B2	
	
	.B LDYABS
	.W $123
	.B LDYABS
	.W $CDCB
	.B LDYABS
	.W W1
	.B LDYABS
	.W W2
	
	.B LDYABX
	.W $123
	.B LDYABX
	.W $CDCB
	.B LDYABX
	.W W1
	.B LDYABX
	.W W2

; CPX AND CPY

TSTCPS

CPXIMM .= $E0
CPXZPG .= $E4
CPXABS .= $EC
CPYIMM .= $C0
CPYZPG .= $C4
CPYABS .= $CC

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	CPX #$5		; IMMEDIATE
	CPX #$E5
	CPX #B1
	CPX #B2
	
	CPX $5		; ZERO PAGE LOCATIONS
	CPX $E5
	CPX B1
	CPX B2
	
	CPX $123	; ABSOLUTE LOCATIONS
	CPX $CDCB
	CPX W1
	CPX W2

	CPY #$5		; IMMEDIATE
	CPY #$E5
	CPY #B1
	CPY #B2
	
	CPY $5		; ZERO PAGE LOCATIONS
	CPY $E5
	CPY B1
	CPY B2
	
	CPY $123	; ABSOLUTE LOCATIONS
	CPY $CDCB
	CPY W1
	CPY W2
	
	.B $00	; indicates end of source
	
.DATA	.B CPXIMM
	.B $5
	.B CPXIMM
	.B $E5
	.B CPXIMM
	.B B1
	.B CPXIMM
	.B B2
	
	.B CPXZPG
	.B $5
	.B CPXZPG
	.B $E5
	.B CPXZPG
	.B B1
	.B CPXZPG
	.B B2
	
	.B CPXABS
	.W $123
	.B CPXABS
	.W $CDCB
	.B CPXABS
	.W W1
	.B CPXABS
	.W W2
	
	.B CPYIMM
	.B $5
	.B CPYIMM
	.B $E5
	.B CPYIMM
	.B B1
	.B CPYIMM
	.B B2

	.B CPYZPG
	.B $5
	.B CPYZPG
	.B $E5
	.B CPYZPG
	.B B1
	.B CPYZPG
	.B B2

	.B CPYABS
	.W $123
	.B CPYABS
	.W $CDCB
	.B CPYABS
	.W W1
	.B CPYABS
	.W W2

; BIT AND STY

TSTBSY

BITZPG .= $24
BITABS .= $2C
STYZPG .= $84
STYABS .= $8C
STYZPX .= $94

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	BIT $5		; ZERO PAGE LOCATIONS
	BIT $E5
	BIT B1
	BIT B2
	
	BIT $123	; ABSOLUTE LOCATIONS
	BIT $CDCB
	BIT W1
	BIT W2

	STY $5		; ZERO PAGE LOCATIONS
	STY $E5
	STY B1
	STY B2
	
	STY $123	; ABSOLUTE LOCATIONS
	STY $CDCB
	STY W1
	STY W2

	STY $5,X	; ZERO PAGE INDEXED,X
	STY $E5,X
	STY B1,X
	STY B2,X
	
	.B $00	; indicates end of source
	
.DATA	.B BITZPG
	.B $5
	.B BITZPG
	.B $E5
	.B BITZPG
	.B B1
	.B BITZPG
	.B B2
	
	.B BITABS
	.W $123
	.B BITABS
	.W $CDCB
	.B BITABS
	.W W1
	.B BITABS
	.W W2
	
	.B STYZPG
	.B $5
	.B STYZPG
	.B $E5
	.B STYZPG
	.B B1
	.B STYZPG
	.B B2

	.B STYABS
	.W $123
	.B STYABS
	.W $CDCB
	.B STYABS
	.W W1
	.B STYABS
	.W W2
	
	.B STYZPX
	.B $5
	.B STYZPX
	.B $E5
	.B STYZPX
	.B B1
	.B STYZPX
	.B B2

; JMP AND JSR

TSTJMP

JMPABS .= $4C
JMPIND .= $6C
JSRABS .= $20

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	CMP #ALTEND
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	JMP $1		; ABSOLUTE LOCATIONS
	JMP $CD
	JMP $123
	JMP $CDCB
	JMP B1
	JMP B2
	JMP W1
	JMP W2
	
	JMP ($1)	; ABSOLUTE INDIRECT
	JMP ($CD)
	JMP ($123)
	JMP ($CDCB)
	JMP (B1)
	JMP (B2)
	JMP (W1)
	JMP (W2)
	
	JSR $1		; ABSOLUTE INDIRECT
	JSR $CD
	JSR $123
	JSR $CDCB
	JSR B1
	JSR B2
	JSR W1
	JSR W2
	
	.B ALTEND	; indicates end of source
	
.DATA	.B JMPABS
	.W $1
	.B JMPABS
	.W $CD
	.B JMPABS
	.W $123
	.B JMPABS
	.W $CDCB
	.B JMPABS
	.W B1		; note must be .W not .B
	.B JMPABS
	.W B2
	.B JMPABS
	.W W1
	.B JMPABS
	.W W2
	
	.B JMPIND
	.W $1
	.B JMPIND
	.W $CD
	.B JMPIND
	.W $123
	.B JMPIND
	.W $CDCB
	.B JMPIND
	.W B1
	.B JMPIND
	.W B2
	.B JMPIND
	.W W1
	.B JMPIND
	.W W2

	.B JSRABS
	.W $1
	.B JSRABS
	.W $CD
	.B JSRABS
	.W $123
	.B JSRABS
	.W $CDCB
	.B JSRABS
	.W B1
	.B JSRABS
	.W B2
	.B JSRABS
	.W W1
	.B JSRABS
	.W W2
	
; SINGLE BYTE INSTRUCTIONS

TSTSNG

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	CMP #ALTEND
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	PHP 
	PLP
	PHA
	PLA
	DEY
	TAY
	INY
	INX
	CLC
	SEC
	CLI
	SEI
	TYA
	CLV
	CLD
	SED
	TXA
	TXS
	TAX
	TSX
	DEX
	NOP
	BRK
	RTI
	RTS

	.B ALTEND	; indicates end of source
	
.DATA	.B $08
	.B $28
	.B $48
	.B $68
	.B $88
	.B $A8
	.B $C8
	.B $E8
	.B $18
	.B $38
	.B $58
	.B $78
	.B $98
	.B $B8
	.B $D8
	.B $F8
	.B $8A
	.B $9A
	.B $AA
	.B $BA
	.B $CA
	.B $EA
	.B $00
	.B $00
	.B $40
	.B $60

; BRANCH INSTRUCTIONS

TSTBRA

BPLREL .= $10
BMIREL .= $30
BVCREL .= $50
BVSREL .= $70
BCCREL .= $90
BCSREL .= $B0
BNEREL .= $D0
BEQREL .= $F0

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .BPL,X
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.BPL	BPL .BPL
	BPL .BPL+80
	BPL .BPL+2
	BPL .BPL-5
	BPL *
	BPL *+17
	BPL *-75

.BMI	BMI .BMI
	BMI .BMI+80
	BMI .BMI+2
	BMI .BMI-5
	BMI *
	BMI *+17
	BMI *-75	

.BVC	BVC .BVC
	BVC .BVC+80
	BVC .BVC+2
	BVC .BVC-5
	BVC *
	BVC *+17
	BVC *-75

.BVS	BVS .BVS
	BVS .BVS+80
	BVS .BVS+2
	BVS .BVS-5
	BVS *
	BVS *+17
	BVS *-75
	
.BCC	BCC .BCC
	BCC .BCC+80
	BCC .BCC+2
	BCC .BCC-5
	BCC *
	BCC *+17
	BCC *-75
	
.BCS	BCS .BCS
	BCS .BCS+80
	BCS .BCS+2
	BCS .BCS-5
	BCS *
	BCS *+17
	BCS *-75
	
.BNE	BNE .BNE
	BNE .BNE+80
	BNE .BNE+2
	BNE .BNE-5
	BNE *
	BNE *+17
	BNE *-75

.BEQ	BEQ .BEQ
	BEQ .BEQ+80
	BEQ .BEQ+2
	BEQ .BEQ-5
	BEQ *
	BEQ *+17
	BEQ *-75
	
	.B $00	; indicates end of source
	
.DATA	.B BPLREL
	.B $FE
	.B BPLREL
	.B $7C
	.B BPLREL
	.B $FC
	.B BPLREL
	.B $F3
	.B BPLREL
	.B $FE
	.B BPLREL
	.B $15
	.B BPLREL
	.B $89	

	.B BMIREL
	.B $FE
	.B BMIREL
	.B $7C
	.B BMIREL
	.B $FC
	.B BMIREL
	.B $F3
	.B BMIREL
	.B $FE
	.B BMIREL
	.B $15
	.B BMIREL
	.B $89	

	.B BVCREL
	.B $FE
	.B BVCREL
	.B $7C
	.B BVCREL
	.B $FC
	.B BVCREL
	.B $F3
	.B BVCREL
	.B $FE
	.B BVCREL
	.B $15
	.B BVCREL
	.B $89	

	.B BVSREL
	.B $FE
	.B BVSREL
	.B $7C
	.B BVSREL
	.B $FC
	.B BVSREL
	.B $F3
	.B BVSREL
	.B $FE
	.B BVSREL
	.B $15
	.B BVSREL
	.B $89	

	.B BCCREL
	.B $FE
	.B BCCREL
	.B $7C
	.B BCCREL
	.B $FC
	.B BCCREL
	.B $F3
	.B BCCREL
	.B $FE
	.B BCCREL
	.B $15
	.B BCCREL
	.B $89	

	.B BCSREL
	.B $FE
	.B BCSREL
	.B $7C
	.B BCSREL
	.B $FC
	.B BCSREL
	.B $F3
	.B BCSREL
	.B $FE
	.B BCSREL
	.B $15
	.B BCSREL
	.B $89	

	.B BNEREL
	.B $FE
	.B BNEREL
	.B $7C
	.B BNEREL
	.B $FC
	.B BNEREL
	.B $F3
	.B BNEREL
	.B $FE
	.B BNEREL
	.B $15
	.B BNEREL
	.B $89	

	.B BEQREL
	.B $FE
	.B BEQREL
	.B $7C
	.B BEQREL
	.B $FC
	.B BEQREL
	.B $F3
	.B BEQREL
	.B $FE
	.B BEQREL
	.B $15
	.B BEQREL
	.B $89	

; VARIOUS EXPRESSIONS

TSTEXP

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	CMP #ALTEND
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	CMP #$5+5	; CONSTANTS
	CMP #$E5-25
	CMP #B1+25
	CMP #B2-5
	
	CMP $5+25	; ZERO PAGE LOCATIONS
	CMP $E5-5
	CMP <B1-25
	CMP B2+5
	CMP <$123+5	
	CMP <$CDCB-25
	CMP <W1-25
	CMP <W2+5
	CMP >$123-5	
	CMP >$CDCB+25
	CMP >W1+25
	CMP >W2-5

	CMP $5+5,X	; ZERO PAGE INDEXED,X
	CMP $E5-25,X
	CMP B1+25,X
	CMP B2-5,X
	CMP >$123-5,X	
	CMP >$CDCB+25,X
	CMP >W1-25,X
	CMP >W2+5,X
	CMP <$123+5,X	
	CMP <$CDCB-25,X
	CMP <W1+25,X
	CMP <W2-5,X

	STX $5+5,Y	; ZERO PAGE INDEXED,Y
	STX $E5-25,Y
	STX B1+25,Y
	STX B2-5,Y
	STX >$123+5,Y	
	STX >$CDCB-25,Y
	STX >W1+25,Y
	STX >W2-5,Y
	STX <$123-5,Y	
	STX <$CDCB+25,Y
	STX <W1-25,Y
	STX <W2+5,Y
	
	CMP $123+5	; ABSOLUTE LOCATIONS
	CMP $CDCB-25
	CMP W1-25
	CMP W2-5
	
	CMP $123+25,X	; ABSOLUTE INDEXED,X
	CMP $CDCB-5,X
	CMP W1-5,X
	CMP W2+25,X
	
	CMP $123-5,Y	; ABSOLUTE INDEXED,Y
	CMP $CDCB+25,Y
	CMP W1-25,Y
	CMP W2+5,Y
	
	CMP ($5+25,X)	; INDEXED INDIRECT,X
	CMP ($E5-5,X)
	CMP (B1+5,X)
	CMP (B2-25,X)
	CMP (>$123-5,X)	
	CMP (>$CDCB+25,X)
	CMP (>W1-25,X)
	CMP (>W2+5,X)
	CMP (<$123+5,X)	
	CMP (<$CDCB-25,X)
	CMP (<W1+25,X)
	CMP (<W2-5,X)
	
	CMP (<$5-25),Y	; INDIRECT INDEXED,Y
	CMP ($E5+5),Y
	CMP (B1+5),Y
	CMP (B2-25),Y
	CMP (>$123+5),Y	
	CMP (>$CDCB-25),Y
	CMP (>W1+25),Y
	CMP (>W2-5),Y
	CMP (<$123-5),Y	
	CMP (<$CDCB+25),Y
	CMP (<W1-25),Y
	CMP (<W2+5),Y
	
	.B ALTEND	; indicates end of source
	
.DATA	.B CMPIMM
	.B $0A
	.B CMPIMM
	.B $C0
	.B CMPIMM
	.B $2A
	.B CMPIMM
	.B $E0
	
	.B CMPZPG
	.B $2A
	.B CMPZPG
	.B $E0
	.B CMPZPG
	.B $E0
	.B CMPZPG
	.B $EA
	.B CMPZPG
	.B $28
	.B CMPZPG
	.B $A6
	.B CMPZPG
	.B $FE
	.B CMPZPG
	.B $D0
	.B CMPZPG
	.B $01
	.B CMPZPG
	.B $CD
	.B CMPZPG
	.B $01
	.B CMPZPG
	.B $CD
	
	.B CMPZPX
	.B $0A
	.B CMPZPX
	.B $C0
	.B CMPZPX
	.B $2A
	.B CMPZPX
	.B $E0
	.B CMPZPX
	.B $01
	.B CMPZPX
	.B $CD
	.B CMPZPX
	.B $00
	.B CMPZPX
	.B $CD
	.B CMPZPX
	.B $28
	.B CMPZPX
	.B $A6
	.B CMPZPX
	.B $48
	.B CMPZPX
	.B $C6
	
	.B STXZPY
	.B $0A
	.B STXZPY
	.B $C0
	.B STXZPY
	.B $2A
	.B STXZPY
	.B $E0
	.B STXZPY
	.B $01
	.B STXZPY
	.B $CD
	.B STXZPY
	.B $01
	.B STXZPY
	.B $CD
	.B STXZPY
	.B $1E
	.B STXZPY
	.B $F0
	.B STXZPY
	.B $FE
	.B STXZPY
	.B $D0	
	
	.B CMPABS
	.W $128
	.B CMPABS
	.W $CDA6
	.B CMPZPG
	.B $FE
	.B CMPABS
	.W $CDC6
	
	.B CMPABX
	.W $148
	.B CMPABX
	.W $CDC6
	.B CMPABX
	.W $11E
	.B CMPABX
	.W $CDF0
	
	.B CMPABY
	.W $11E
	.B CMPABY
	.W $CDF0
	.B CMPABY
	.W $FE
	.B CMPABY
	.W $CDD0
	
	.B CMPINX
	.B $2A
	.B CMPINX
	.B $E0
	.B CMPINX
	.B $0A
	.B CMPINX
	.B $C0
	.B CMPINX
	.B $01
	.B CMPINX
	.B $CD
	.B CMPINX
	.B $00
	.B CMPINX
	.B $CD
	.B CMPINX
	.B $28
	.B CMPINX
	.B $A6
	.B CMPINX
	.B $48
	.B CMPINX
	.B $C6
	
	.B CMPINY
	.B $E0
	.B CMPINY
	.B $EA
	.B CMPINY
	.B $0A
	.B CMPINY
	.B $C0
	.B CMPINY
	.B $01
	.B CMPINY
	.B $CD
	.B CMPINY
	.B $01
	.B CMPINY
	.B $CD
	.B CMPINY
	.B $1E
	.B CMPINY
	.B $F0
	.B CMPINY
	.B $FE
	.B CMPINY
	.B $D0

; DIRECTIVES

TSTDIR

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX	
	LDA .SRC,X
	CMP #ALTEND
	BEQ .DONE
	CMP .DATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	.B B1
	.B B2
	.W $123
	.W $CDCB
	.W W1
	.W W2
	
	.B B1+25
	.B B2+05
	.W $123+25
	.W $CDCB+25
	.W W1+25
	.W W2+25
	
	.B <B1-25
	.B B2-25
	.W $123-25
	.W $CDCB-25
	.W W1-25
	.W W2-25
	
	.B <W1
	.B <W2
	.B <W1+25
	.B <W2+25
	.B <W1-25
	.B <W2-25
	
	.B >W1
	.B >W2
	.B >W1+25
	.B >W2+05
	.B >W1-25
	.B >W2-25
	
	.S 'ABCDE'
	
	.B ALTEND	; indicates end of source
	
.DATA	.B $5
	.B $E5
	.B $23
	.B $01
	.B $CB
	.B $CD
	.B $23
	.B $01
	.B $CB
	.B $CD

	.B $2A
	.B $EA
	.B $48
	.B $01
	.B $F0
	.B $CD
	.B $48
	.B $01
	.B $F0
	.B $CD
	
	.B $E0
	.B $C0
	.B $FE
	.B $00
	.B $A6
	.B $CD
	.B $FE
	.B $00
	.B $A6
	.B $CD

	.B $23
	.B $CB
	.B $48
	.B $F0
	.B $FE
	.B $A6

	.B $01
	.B $CD
	.B $01
	.B $CD
	.B $00
	.B $CD
	
	.B $41;'A'
	.B $42;'B'
	.B $43;'C'
	.B $44;'D'
	.B $45;'E'

; FORWARD REFERENCES

TSTFRF

.TEST	LDA #<.TEST	; SAVE ADDRESS OF THIS ROUTINE
	STA SRCL
	LDA #>.TEST
	STA SRCH
	LDX #$FF
.LOOP	INX
	LDA .SRC,X
	BEQ .DONE
	CMP FDATA,X
	BEQ .LOOP
	JSR ERROR
.DONE	RTS

.SRC	LDA FREF1
	LDA FREF1+3
	LDA FREF1-7
	BPL .FREF
	BPL .FREF+3
	BPL .FREF-7
.FREF	LDA FREF2
	LDA FREF2+3
	LDA FREF2-7
	
	.B $00	; indicates end of source
	
FREF1	.= $5678
	
FDATA	.B LDAABS
	.W FREF1
	.B LDAABS
	.W FREF1+3
	.B LDAABS
	.W FREF1-7
	.B BPLREL
	.B $04
	.B BPLREL
	.B $05
	.B BPLREL
	.B $F9
	.B LDAABS
	.W $9ABC
	.B LDAABS
	.W $9ABC+3
	.B LDAABS
	.W $9ABC-7
	
NEWMOD	
FREF2	.= $9ABC
	
; ****************************************
; I/O routines
; ****************************************

OUTSP	
	LDA #SP
	JMP OUTCH
	
CRLF			; Go to a new line.
	LDA #CR		; 'CR'
	JMP OUTCH

GETCH   		; Get a character from the keyboard.
	LDA KBDRDY
	BPL GETCH
	LDA KBD
	AND #INMASK
	RTS	
